function [class] = punc_colo_s(punc_data,ori,chan,varargin)
%Synatax:   [class] = punc_colo_s(punc_data,1,[2 4 7],'termi',3,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',[0 1 0]);
%Input:     punc_data = the original puncta data structure from
%                   punc_locodist.
%           ori = the channel you want to use as the central pivot
%           chan = channel or channels that you want colocalized with your
%                   ori channel.
%           termi = termi once specificed, kicks the function into uber
%                   classify mode, or elastic distance threshold mode,
%                   essentially create a ori-termi distance filter base
%                   vector
%           mod = 0 or 1.  0 = off (default) 1 = on.  When on the distance
%                   of the punctas are modified by the properties of
%                   punctas.
%           mod_fltr = 0 or 1. 0 = off(default) 1 = on.  When any parameter
%                   of a puncta that puts it 3std away will remove the
%                   puncta from consideration.
%           pp_fltr = 0 or 1.  1 = on 0 = off(default).
%           prepost = a vector the same length as chan.  0 =
%                   near ori, 1i = near termi.  If pp_fltr is on and
%                   this is left blank, all channels will be considered
%                   near ori (0).  Now everything works the same, but
%                   numbers above 0, e.g. 2, 13, now will modify distance
%                   near termi, such that the termi point will be accepted
%                   if the distance to the termi is d.termi-2 or 13 <d.ori.
%                   Numbers below 0, e.g., -2,-13 now modify distance near
%                   ori, i.e., d.ori-2 or 13 <d.termi.  1i is special in
%                   that 1i is actually 0 for termi distances. 100i means
%                   no perferences, can be used for Astrocytes.  Note:
%                   positive numbers bring points together, either ori or
%                   termi, and negative number pushes the points apart.
%Output:    class = The structure contains fields: number, vertex, name
%                   Number: is the number of occurance of this class in the
%                           dataset.
%                   Vertex: the ori vertex that
%                   Channels: the channels included in this category, e.g.,
%                   [1 3 5]
%                   names: the names of those channels
%                   threshold: the thresholds used for each channel.
%                   total_number: all the points that colo with all channels
%                   total_vertices: all the vertices that colo with all
%                       channels
%                   total_distances: all the distances of the channels away
%                       from the vertices that colo with all channels
%                   when uber is activated it just spits out an extra
%                   dataset similar to total, with slide infront.

%extract out some important data.
vertices = punc_data(ori).vertices(:,1:3);     %the vertices in question
distances = punc_data(ori).distance;    %the distances to all of the other channels

%rework the distance a little for easy use.
distances = distances(:,1,chan);       %we only need the distances for the channels we are interested
distances = reshape(distances,size(distances,1),size(chan,2));     %flatten in a xy array.

%now parse threshold & error check
[mod,mod_fltr,termi,pp_fltr,prepost,visual,multi] = parse(varargin,chan);

%create the modification index of the origin
if mod
    %pull some needed data
    vert_prop_ori = punc_data(ori).vert_all_prop;
    %figure out the modifier
    %get the medians for all props first
    %[y,x] = find(isnan(vert_prop_ori));   %remove not a number first
    vert_prop_tmp = vert_prop_ori;       %temp the variable to be worked on
    %vert_prop_tmp(y,:) = [];     %gone
    meds_ori = median(vert_prop_tmp);    %median
    %generate ori modification index
    ori_mod_idx = mean(vert_prop_ori./repmat(meds_ori,size(vert_prop_ori,1),1),2);
    %filter ori for outliers
    if mod_fltr
        %create the outlier filter array
        outlier_fltr = repmat((std(vert_prop_tmp)*3+meds_ori),size(vert_prop_ori,1),1);    %3 std away is too far
        %now filter out the outliers
        outlier_fltr = outlier_fltr<=vert_prop_ori;
        for i = 1:size(outlier_fltr,2)
            ori_mod_idx(outlier_fltr(:,i)) = NaN;   %outliers set to NaN
        end
    end
    %clear
    vert_prop_tmp = [];outlier_fltr = [];
end

%are you prepared for uber...are you?

%ok lets pull out the sliding threshold channel.
s_thresh = punc_data(ori).distance(:,1,termi);
%initialize and preallocate
ytotal = [];
%now loosely filter the slideing threshold for far out data
[yfar,x] = find(s_thresh>(median(s_thresh(~isnan(s_thresh)))+std(s_thresh(~isnan(s_thresh)))*2));
[ynan,x] = find(isnan(s_thresh));
%now give s_thresh a little wiggle room
%s_thresh = s_thresh+repmat(std(s_thresh(~isnan(s_thresh))),size(s_thresh,1),1);     %give it 1 STD wiggle room
%get the termini location of the base vector
base_termi_vert = punc_data(ori).termi(:,:,termi);
%create the modification index of the sliding index(base vector)
if mod
    %pull some needed data
    vert_prop_termi = punc_data(ori).termi_prop(:,:,termi);
    %figure out the modifier
    %get the medians for all props first
    [y,x] = find(isnan(vert_prop_termi));   %remove not a number first
    vert_prop_tmp = vert_prop_termi;       %temp the variable to be worked on
    vert_prop_tmp(y,:) = [];     %gone
    meds_termi = median(vert_prop_tmp);    %median
    %generate ori modification index
    termi_mod_idx = mean(vert_prop_termi./repmat(meds_termi,size(vert_prop_termi,1),1),2);
    %filter termi for outliers
    if mod_fltr
        %create the outlier filter array
        outlier_fltr = repmat((std(vert_prop_tmp)*3+meds_termi),size(vert_prop_termi,1),1);    %3 std away is too far
        %now filter out the outliers
        outlier_fltr = outlier_fltr<=vert_prop_termi;
        for i = 1:size(outlier_fltr,2)
            termi_mod_idx(outlier_fltr(:,i)) = NaN;   %outliers set to NaN
        end
    end
    %now using the ori and termi mod indexs to create the final mod
    mod_idx = mean([termi_mod_idx ori_mod_idx],2);
    %modifty the threshold based on the punctas at then ori and termini
    %of the base vector
    s_thresh = s_thresh.*mod_idx;
    %OK now set an upper bound on the colo distance
    %any modifed distance greater than 2.5um is too far so:
    %s_thresh(s_thresh>25) = 25;     %set to 25
    %clear
    vert_prop_tmp = [];outlier_fltr = [];
end
%now step through the channels
for j = 1:size(chan,2)
    if chan(j)~=termi && chan(j)~=ori       %no ori or termi in this comparision
        vertex = vertices;          %new variable so we do not destroy vertices.
        distance = distances(:,j);  %pull out the relavent distances
        termi_vert = punc_data(ori).termi(:,:,chan(j));     %the terminal vertices
        %modify the distance based on the puncta parameters
        if mod
            %pull some needed data
            vert_prop = punc_data(ori).termi_prop(:,:,chan(j));
            %figure out the modifier
            %get the medians for all props first
            [y,x] = find(isnan(vert_prop));   %remove not a number first
            vert_prop_tmp = vert_prop;       %temp the variable to be worked on
            vert_prop_tmp(y,:) = [];     %gone
            meds_curr = median(vert_prop_tmp);    %median
            %modify the distances (Note: turned off because I don't think
            %we should to do it.  Turn it back on if you think it is wise.
            %Try it, it should be fun. Essentially this will tend to
            %exclude large punctas, which could be a good or bad thing
            %depending on your dataset.)
            %distance = (distance.*ori_mod_idx)./mean(vert_prop./repmat(meds_curr,size(vert_prop,1),1),2);
            %filter vertices for outliers
            if mod_fltr
                %create the outlier filter array
                outlier_fltr = repmat((std(vert_prop_tmp)*3+meds_curr),size(vert_prop,1),1);    %3 std away is too far
                %now filter out the outliers
                outlier_fltr = outlier_fltr<=vert_prop;
                for k = 1:size(outlier_fltr,2)
                    distance(outlier_fltr(:,k)) = NaN;   %outliers set to NaN
                end
            end
            %clear
            vert_prop_tmp = [];outlier_fltr = [];
        end
        %lets filter based on proximity to ori or termi priors
        if pp_fltr==1  %type 1, recalculate distance based on vertices here
            pp_ori = vertex;  %get the ori vertices
            pp_termi = base_termi_vert; %get the actual terminal vertices.
            pp_comp = termi_vert;  %matching termi (third channel)
            %now calculate distances and determine elegibility of the
            %vertex
            ypp = zeros(size(pp_comp,1),1);     %preallocate
            for k = 1:size(pp_comp,1)
                switch prepost(1,j)
                    case 0      %closer to ori
                        ypp(k,1) = dddist(pp_ori(k,:),pp_comp(k,:))>dddist(pp_termi(k,:),pp_comp(k,:));
                    case 1i      %closer to termi
                        ypp(k,1) = dddist(pp_ori(k,:),pp_comp(k,:))<dddist(pp_termi(k,:),pp_comp(k,:));
                    case 100i     %ignostic
                        ypp = [];  %do not filter anything
                    otherwise       %modify by prepost number
                        if prepost(1,j)<=0       %closer to ori
                            ypp(k,1) = dddist(pp_ori(k,:),pp_comp(k,:))>dddist(pp_termi(k,:),pp_comp(k,:))/abs(prepost(1,j));  %ori must be closer than termi
                        else                    %closer to termi
                            ypp(k,1) = dddist(pp_ori(k,:),pp_comp(k,:))/abs(prepost(1,j))<dddist(pp_termi(k,:),pp_comp(k,:));  %ori must be further than termi
                        end
                end
                if visual
                    vcheck(pp_ori,pp_termi,pp_comp,ypp,prepost(1,i),curr_colo_dist(k,1));
                    keyboard
                    close all
                end
            end
        else
            ypp = [];           %index not used.
        end
        ypp = find(ypp==1);     %creat actual index
        [ytmp,x] = find(isnan(distance));       %remove the nan in this data set as well
        [y,x] = find(distance>s_thresh);         %get the location of non colocolizers
        y = unique(vertcat(y,ytmp,yfar,ynan,ypp));        %remove all unmatch or unqualified data points
        distance(y,:) = [];         %gone
        vertex(y,:) = [];                            %gone
        termi_vert(y,:) = [];       %gone
        ytotal = vertcat(ytotal,y);           %add to the total index.
        %now store the data
        class(j).s_chan_idx = y;                %the index of removal for that channel
        class(j).s_number = size(vertex,1);     %number of occurances of this class in the data set.
        class(j).s_distance = distance;         %the colo distances
        class(j).s_ori_vert = vertex;           %the vertices of the colo occurances in the data set.
        class(j).s_termi_vert = termi_vert;     %the termi vertices
        if mod
            ori_prop_tmp = vert_prop_ori;   %get a copy of ori properties
            vert_prop(y,:) = [];    %gone
            class(j).s_termi_prop = vert_prop;       %the properties of the colocalized vertices
            ori_prop_tmp(y,:) = [];     %gone
            class(j).s_ori_prop = ori_prop_tmp;     %the properties of the ori channel
        end
    end
end
%clean up total index
ytotal = unique(ytotal);
%now generated the final all colo dataset
distances(ytotal,:) = [];        %gone
vertices(ytotal,:) = [];         %gone
base_termi_vert(ytotal,:) = [];  %gone
%store uber data
class(1).s_total_idx = ytotal;         %the total index.
class(1).s_total_distances = distances;     %the distances of points that colo with all channels
class(1).s_total_ori_vert = vertices;       %the vertices that colo with all channels
class(1).s_total_number = size(vertices,1); %the number of vertices that colo with all channels
class(1).s_total_termi_vert = base_termi_vert;  %the vertices of the terminal channel
if mod
    vert_prop_ori(ytotal,:) = [];    %gone
    class(1).s_total_ori_prop = vert_prop_ori;      %the properties for the ori channel
    vert_prop_termi(ytotal,:) = [];  %gone
    class(1).s_total_termi_prop = vert_prop_termi;      %the properties for the ori channel
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [mod,mod_fltr,termi,pp_fltr,prepost,visual,multi] = parse(input,chan)

mod = 0;  %Default Initialized.
mod_fltr = 0;
termi = chan(1,1);    %base scale of a unit in the x axis
pp_fltr = 0;        %off by default.
prepost = [];      %logically no.
visual = 0;
multi = 1;  %default

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'mod'
                    mod = input{1,i+1};
                case 'mod_fltr'
                    mod_fltr = input{1,i+1};
                case 'termi'
                    termi = input{1,i+1};
                case 'pp_fltr'
                    pp_fltr = input{1,i+1};
                case 'prepost'
                    prepost = input{1,i+1};
                case 'visual'
                    visual = input{1,i+1};
                case 'multi'
                    multi = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        end
    end
end
%lets parse the pre post filtering a little more
if pp_fltr
    if isreal(prepost)&&isempty(prepost)         %filter is on, but prepost left blank
        prepost = zeros(size(chan));  %everything channel is considered near ori
    end
end
%if visual is on then multi must be off
if visual
    if multi
        multi = 0;
    end
end
%--------------------------------------------------------------------------
%Little function to allow the visual check of the data
function [] = vcheck(pp_ori,pp_termi,pp_comp,ypp,prepost,colodistmod)
scatter(0,0);   %plot the origin
hold;    %hold it
fverts = unique(flat_verts(pp_termi-pp_ori),'rows');   %translate termi
fverts2 = unique(flat_verts(pp_comp-pp_ori),'rows');   %translate third
%plot them
scatter(fverts(1,1),fverts(1,2));
scatter(fverts2(:,1),fverts2(:,2));
%calculate the distances
o_third = dddist(pp_ori,pp_comp);  %ori to third
t_third = dddist(pp_termi,pp_comp);  %termi to third
%colocalization sphere distance
colodist = dddist(pp_ori,pp_termi);
switch prepost
    case 0      %closer to ori
        omod = nan(size(o_third));
        tmod = t_third;
    case 1i      %closer to termi
        omod = o_third;
        tmod = nan(size(t_third));
    case 100i     %ignostic
        omod = nan(size(o_third));
        tmod = nan(size(t_third));
    otherwise       %modify by prepost number
        if prepost<=0       %closer to ori
            omod = nan(size(o_third));
            tmod = t_third/prepost;
        else                    %closer to termi
            tmod = nan(size(t_third));
            omod = o_third/prepost;
        end
end
output = [o_third,omod,t_third,tmod,ypp,colodist,repmat(colodistmod,size(ypp,1),1)];
labels = {'ori-third','mod','termi-third','mod','accept','colodist','mod'};
output = dataset({output,labels{:}});
display(output);